/*
 * Decompiled with CFR 0.152.
 */
package BryceGraphs.gui_components.nodes;

import BryceGraphs.ADTs.EditableGNode;
import BryceGraphs.ADTs.Serials.SerialAdjacencyNode;
import BryceGraphs.gui_components.gui_EditableGNode;
import BryceMath.Geometry.Rectangle;
import Data_Structures.Structures.HashingClasses.Dict;
import Data_Structures.Structures.List;
import Game_Engine.GUI.Components.Functional.gui_ActionButton;
import Game_Engine.GUI.Components.Input.textBased.gui_StringInput;
import Game_Engine.GUI.Components.small.gui_button;
import Game_Engine.levelEditor.room_fileChooser;
import java.io.File;
import java.io.PrintStream;
import java.util.Iterator;
import util.interfaces.Action;

public class gnode_file
implements EditableGNode,
SerialAdjacencyNode<gnode_file> {
    private File myFile;
    List<gnode_file> children = new List();
    final room_fileChooser file_chooser;
    gui_StringInput levelName;
    private gui_EditableGNode display;

    public gnode_file(File file, String name, room_fileChooser room_chooser) {
        this.myFile = file;
        this.file_chooser = room_chooser;
        this.levelName = new gui_StringInput(0.0, 0.0, 0, 20);
        if (name != null) {
            this.levelName.populateInput(name);
        } else {
            this.levelName.populateInput("[No Name Yet]");
        }
        this.levelName.fitToContents();
    }

    @Override
    public String getGNodeName() {
        return this.getFileSource();
    }

    private String getFileSource() {
        return this.levelName.getInput();
    }

    private String getFileName() {
        if (this.myFile != null) {
            return this.myFile.getName();
        }
        return "[Empty Node]";
    }

    @Override
    public void getGNodeData(Dict<Object> map) {
        map.insert("Source:", this.getFileName());
        int i = 0;
        for (gnode_file gnode : this.children) {
            map.insert("child" + i, gnode);
            ++i;
        }
    }

    @Override
    public void populateEditField(gui_EditableGNode node, int ROW_H) {
        this.display = node;
        this.levelName.setH(ROW_H);
        node.addField("Name : ", this.levelName);
        FileChanger b = new FileChanger(0.0, 0.0, 0, ROW_H);
        if (this.myFile != null) {
            b.setText(this.myFile.getName());
        }
        b.fitToContents();
        node.addField("Source : ", b);
        Rectangle bounds = new Rectangle(0, 0, 0, ROW_H);
        for (gnode_file file : this.children) {
            node.GNode("Child", file, bounds);
        }
        gui_ActionButton child_adder = new gui_ActionButton(bounds, new childAdder(ROW_H));
        child_adder.setText("New Child");
        child_adder.fitToContents();
        node.addObj(child_adder);
        gui_ActionButton a = new gui_ActionButton(bounds, new action_edit());
        a.setText("Edit Level");
        a.fitToContents();
        node.addObj(a);
        a = new gui_ActionButton(bounds, new action_edit());
        a.setText("Run Level");
        a.fitToContents();
        node.addObj(a);
    }

    private gnode_file NEW_CHILD() {
        return new gnode_file(null, null, this.file_chooser);
    }

    public File getFile() {
        return this.myFile;
    }

    @Override
    public String getSerialName() {
        return "gnode_file_graph_node";
    }

    @Override
    public void serializeTo(PrintStream stream) {
        stream.println(this.myFile);
        stream.println(this.levelName.getInput());
    }

    public static gnode_file deserialize(Iterator<String> data, room_fileChooser chooser) {
        File file = new File(data.next());
        String name = data.next();
        return new gnode_file(file, name, chooser);
    }

    @Override
    public Iterable<gnode_file> getNeighbors() {
        return this.children;
    }

    @Override
    public int getNeighborSize() {
        return this.children.size();
    }

    @Override
    public void setNeighbors(Iterable<gnode_file> neighbors) {
        this.children.clear();
        this.children.append(neighbors);
    }

    private class FileChanger
    extends gui_button {
        private boolean calling;

        public FileChanger(double x, double y, int w, int h) {
            super(x, y, w, h);
            this.calling = false;
            this.setText(gnode_file.this.getGNodeName());
            this.fitToContents();
        }

        @Override
        public void update() {
            super.update();
            if (gnode_file.this.levelName.input_changed()) {
                gnode_file.this.levelName.fitToContents(gnode_file.this.levelName.getH());
                gnode_file.this.display.setHandleText(gnode_file.this.levelName.getInput());
            }
            if (this.flag()) {
                gnode_file.this.file_chooser.call(this.getRoom());
                gnode_file.this.file_chooser.getChooser().refresh();
                gnode_file.this.file_chooser.openMode();
                this.calling = true;
                return;
            }
            if (this.calling) {
                this.calling = false;
                File potential_file = gnode_file.this.file_chooser.getFile();
                if (potential_file == null) {
                    return;
                }
                gnode_file.this.myFile = potential_file;
                String name = gnode_file.this.myFile.getName();
                this.setText(name);
                this.fitToContents();
                gnode_file.this.display.updateXMAX((int)this.getX2());
            }
        }
    }

    private class action_edit
    implements Action {
        private action_edit() {
        }

        @Override
        public void action() {
        }
    }

    private class action_run
    implements Action {
        private action_run() {
        }

        @Override
        public void action() {
        }
    }

    private class childAdder
    implements Action {
        final int h;

        public childAdder(int height) {
            this.h = height;
        }

        @Override
        public void action() {
            gnode_file.this.display.GNode("Child", gnode_file.this.NEW_CHILD(), new Rectangle(0, 0, 0, this.h));
        }
    }
}

